import Utilities.gui_creator as gc
import Utilities.plot_creator as pc
import numpy as np
import tkinter.filedialog as fd
import numpy.polynomial.polynomial as npp


fname = fd.askopenfilename()
t, r = np.loadtxt(fname, delimiter=',', usecols=(0,1),
                  unpack=True)

root = gc.create_window(title='Thermistor R-t Data Plot',
                        size='1000x500')
control_box, right_frame = gc.create_frames(root)
ax, canvas = pc.create_plot(right_frame)

pc.update_plot(ax, canvas, t, r,
               label_x='Temperature (deg Celsius)',
               label_y='Resistance (kOhm)',
               marker='o')

x = np.log(r*1000)
y = 1/(t + 273.15)

coef = npp.polyfit(x, y, 3)
a, b, c, d = coef

gc.create_indicator(control_box, label_1='A',
                    label_2=f'{a:.8e}')
gc.create_indicator(control_box, label_1='B', 
                    label_2=f'{b:.8e}')
gc.create_indicator(control_box, label_1='C', 
                    label_2=f'{c:.8e}')
gc.create_indicator(control_box, label_1='D',
                    label_2=f'{d:.8e}')

y_fit = a + b*x + c*x**2 + d*x**3
t_fit = 1/y_fit - 273.15

pc.update_plot(ax, canvas, t_fit, r,
               label_x='Temperature (deg Celsius)',
               label_y='Resistance (kOhm)',
               clear_flag=False)
